unit mVimmEdit;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, mVimMBase, Vcl.StdCtrls, Vcl.ExtCtrls,
  mVimmGrid, Vcl.ComCtrls, ORCtrls, ORDtTm, rVimm, ORFn, Vcl.ImgList,
  Vcl.Buttons, System.ImageList;

type
  TfraImmEdit = class(TfraParent)
    pgeDisplay: TPageControl;
    pnlBottom: TPanel;
    pgBlank: TTabSheet;
    pgAdmin: TTabSheet;
    pgHist: TTabSheet;
    pgRefuse: TTabSheet;
    pgContr: TTabSheet;
    pgDetails: TTabSheet;
    cboLot: TORComboBox;
    lblLot: TLabel;
    lblExpDateText: TLabel;
    lblExpDateValue: TLabel;
    lblManufacturerText: TLabel;
    lblManufacturerValue: TLabel;
    lblCPTText: TLabel;
    pnlLot: TPanel;
    pnlExpDate: TPanel;
    pnlManufacturer: TPanel;
    pnlCodes: TPanel;
    pnlAdminDate: TPanel;
    pnlAdminBy: TPanel;
    pnlOrderBy: TPanel;
    pnlRoute: TPanel;
    pnlLocation: TPanel;
    pnlSeries: TPanel;
    pnlDosage: TPanel;
    pnlVIS: TPanel;
    pnlComments: TPanel;
    gridPanel: TGridPanel;
    dateAdminDate: TORDateBox;
    cboAdminBy: TORComboBox;
    cboOrderBy: TORComboBox;
    cboRoute: TORComboBox;
    cboSite: TORComboBox;
    cboSeries: TORComboBox;
    edtDosage: TEdit;
    cboVIS: TORComboBox;
    comments: TEdit;
    lblAdminDate: TLabel;
    lblAdminBy: TLabel;
    lblOrderBy: TLabel;
    lblRoute: TLabel;
    lblSite: TLabel;
    lblSeries: TLabel;
    lblDosage: TLabel;
    lblVIS: TLabel;
    Label2: TLabel;
    btnOk: TButton;
    btnCancel: TButton;
    pnlRefuse: TPanel;
    lblRefuse: TLabel;
    cboRefuse: TORComboBox;
    pnlWarnDate: TPanel;
    dateWarn: TORDateBox;
    lblWarnDate: TLabel;
    pnlCommentRef: TPanel;
    lblCommentRef: TLabel;
    commentRef: TEdit;
    gridPanelRef: TGridPanel;
    GridPanelContra: TGridPanel;
    pnlContr: TPanel;
    Label4: TLabel;
    cboContra: TORComboBox;
    pnlWarnContr: TPanel;
    Label6: TLabel;
    dateWarnContra: TORDateBox;
    pnlCommentContra: TPanel;
    Label7: TLabel;
    commentContra: TEdit;
    gridPanelHist: TGridPanel;
    pnlLotHist: TPanel;
    Label8: TLabel;
    pnlExpirHist: TPanel;
    Label9: TLabel;
    pnlManufHist: TPanel;
    lblMactHist: TLabel;
    pnlCommentHist: TPanel;
    Label23: TLabel;
    commentsHist: TEdit;
    cboManuf: TORComboBox;
    edtLot: TEdit;
    pnlAdminDateHist: TPanel;
    Label15: TLabel;
    dateAdminHist: TORDateCombo;
    pnlRouteHist: TPanel;
    lblRouteHist: TLabel;
    cboRouteHist: TORComboBox;
    pnlLocationHist: TPanel;
    lblSiteHist: TLabel;
    cboLocHist: TORComboBox;
    pnlSeriesHist: TPanel;
    Label20: TLabel;
    cboSeriesHist: TORComboBox;
    pnlDosageHist: TPanel;
    Label21: TLabel;
    edtDosageHist: TEdit;
    pnlOutSideLoc: TPanel;
    pnlInfoSource: TPanel;
    lblOutLoc: TLabel;
    Label11: TLabel;
    cboOutLoc: TORComboBox;
    cboInfoSource: TORComboBox;
    dateExpiration: TORDateBox;
    memoDetails: TMemo;
    pnlOverride: TPanel;
    lblOverride: TLabel;
    edtOverride: TEdit;
    cboCPT: TORComboBox;
    procedure cboLotClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure dateAdminHistChange(Sender: TObject);
    procedure cboRouteHistClick(Sender: TObject);
    procedure cboRouteClick(Sender: TObject);
    procedure cboAdminByNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
    procedure cboOrderByNeedData(Sender: TObject; const StartFrom: string;
      Direction, InsertAt: Integer);
  private
    procedure setComboBox(control: TControl; name, id: string);
    procedure setControlValue(control: TControl; value: string);
  published
    { Private declarations }
    immSeriesList: TStringList;
    procedure setLotComboBox(immData: String);
    procedure clearValues(isBlank: boolean = false);
    function validate: boolean;
    function adminValidate(var vimmResult: TVimmResult): boolean;
    function historicalValidate(var vimmResult: TVimmResult): boolean;
    function refusalValidate(var vimmResult: TVimmResult): boolean;
    function contraValidate(var vimmResult: TVimmResult): boolean;
    procedure setEditFields(immunization: string);
    procedure setDetails(immunization: string);
    procedure setValues(immData: String);
    procedure setAdminValues(immData: String);
    procedure setDefaultInputValues(immData: String);
    procedure setHistValues(immData: string);
    procedure setRefusalValues(immData: string);
    procedure setContraValues(immData: string);
    procedure setSiteFromRoute(iControl, dControl: TControl);
    procedure setSeriesItems(immunization: string; AControl: TControl);
    procedure setLookupDefaults(cbo: TORComboBox; items: TStrings; Num: integer);
    procedure checkForMultipleCodes(immunization: string);
  protected
    immDataStr: string;
    adminInitialSet: boolean;
    orderName: string;
    orderIEN: string;
    adminName: string;
    adminIEN: string;
    location: string;
    visitStr: string;
  public
    adminDate: TFMDateTime;
    { Public declarations }
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    procedure setPage(page: TTabSheet; immunization: string; edit, needsOverride: boolean);
    procedure setDefaultValues(immunization: string);
    procedure setVISComboBox(immData: string);
    procedure collapse;
    procedure expand;
    procedure setEncounterData(date: TFMDateTime; orderName, orderIEN, adminName, adminIEN, loc, visitStr: string);
    function valiateFromParent: boolean;
  end;

var
  fraImmEdit: TfraImmEdit;

implementation

{$R *.dfm}
 uses
 mVimmSelect;
{ TfraImmEdit }



function TfraImmEdit.adminValidate(var vimmResult: TVimmResult): boolean;
var
idx: integer;
  i: Integer;
begin
  result := true;
  //immunization checkbox
  vimmResult.id := Piece(immDataStr, U, 1);
  vimmResult.name := Piece(immDataStr, u, 2);
  vimmResult.documType := 'Administered';
  //required fields
  //route
  idx := cboRoute.ItemIndex;
  if idx = -1 then result := false
  else
    begin
      vimmResult.routeIEN := Piece(cboRoute.Items[idx], U, 1);
      vimmResult.route := Piece(cboRoute.items[idx], u, 2);
    end;
  //site
  idx := cboSite.ItemIndex;
  if idx = -1 then result := false
  else
    begin
      vimmResult.siteIEN := Piece(cboSite.Items[idx], U, 1);
      vimmResult.site := Piece(cboSite.items[idx], u, 2);
    end;
  //override reason
  if pnlOverride.Visible = true then
    begin
      if edtOverride.Text = '' then result := false
      else vimmResult.overrideReason := edtOverride.Text;
    end;
//  adminBy
  idx := cboAdminBy.ItemIndex;
  if idx = -1 then result := false
  else
    begin
      vimmResult.adminByIEN := Piece(cboAdminBy.Items[idx], U, 1);
      vimmResult.adminBy := Piece(cboAdminBy.items[idx], u, 2);
    end;
  //orderBy
  idx := cboOrderBy.ItemIndex;
  if idx = -1 then result := false
  else
    begin
      vimmResult.orderByIEN := Piece(cboOrderBy.Items[idx], U, 1);
      vimmResult.orderBy := Piece(cboOrderBy.items[idx], u, 2);
    end;
  //lot Needs
  idx := cboLot.ItemIndex;
  if idx > -1 then
    begin
      vimmResult.lotIEN := Piece(cboLot.Items[idx], U, 1);
      vimmResult.lot := Piece(cboLot.Items[idx], U, 2);
      vimmResult.manufacturer := self.lblManufacturerValue.Caption;
      vimmResult.expirationDate := self.lblExpDateValue.Caption;
    end;
  //admin date
  if dateAdminDate.Text = '' then
      begin
        result := false;
        exit;
      end;
    vimmResult.adminDate := dateAdminDate.fmDateTime;
  //VIS
  if cboVis.Items.Count > 0 then
    begin
      for i := 0 to cboVis.Items.Count - 1 do
        begin

          if cboVis.Checked[i] = true then
            begin
              if vimmResult.visList = nil then vimmResult.visList := TStringList.Create;
              vimmResult.visList.Add(Piece(cboVis.Items.Strings[i], U, 1));
            end;
        end;
      if (vimmResult.visList = nil) or (vimMResult.visList.Count = 0) then
        begin
          result := false;
          exit;
        end;
    end;
  //procedure codes
  if (self.pnlCodes.Visible) then
    begin
      idx := cboCPT.ItemIndex;
      if idx = -1 then
        begin
          result := false;
          exit;
        end;
      getCode(vimmResult.id, 'CPT', Piece(cboCPT.Items.Strings[idx], U, 1), vimmResult);
    end;
  //Optional fields
  //series Needs Validation
  idx := cboSeries.ItemIndex;
  if idx > -1 then
    begin
      vimmResult.seriesId := Piece(cboSeries.Items[idx], U, 1);
      vimmResult.series := Piece(cboSeries.Items[idx], U, 2);
    end;

  //dosage Needs Validation
  if edtDosage.Text <> '' then
    begin
      vimmResult.dosage := edtDosage.Text;
    end;
  if result = false then exit;
  getDefaultCodes(vimmResult);
  if comments.Text <> '' then vimmResult.comments := comments.Text;
  clearValues;
end;

procedure TfraImmEdit.btnCancelClick(Sender: TObject);
begin
  clearValues;
end;

procedure TfraImmEdit.btnOkClick(Sender: TObject);
begin
    if not validate then exit;
    clearValues;
    setPage(pgBlank, 'blank', false, false);
end;

procedure TfraImmEdit.cboAdminByNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
var
  aLst: TStringList;
begin
  aLst := TStringList.Create;
  try
    SubSetOfPersons(aLst, startFrom, direction);
    cboAdminBy.ForDataUse(aLst);
  finally
    FreeAndNil(aLst);
  end;

end;

procedure TfraImmEdit.cboLotClick(Sender: TObject);
var
idx: integer;
temp: string;
begin
   idx := cboLot.ItemIndex;
   if idx = -1 then exit;
   temp := cboLot.Items.Strings[idx];
   lblExpDateValue.Caption := Piece(temp, U, 5);
   lblManufacturerValue.Caption := Piece(temp, U, 4);
end;

procedure TfraImmEdit.cboOrderByNeedData(Sender: TObject;
  const StartFrom: string; Direction, InsertAt: Integer);
var
  aLst: TStringList;
begin
  aLst := TStringList.Create;
  try
    subSetOfProviders(aLst, startFrom, direction);
    cboOrderBy.ForDataUse(aLst);
  finally
    FreeAndNil(aLst);
  end;
end;

procedure TfraImmEdit.cboRouteClick(Sender: TObject);
begin
  setSiteFromRoute(self.cboRoute, self.cboSite);
  if self.cboSite.Enabled = false then lblSite.Enabled := false
  else lblSite.Enabled := true;
end;

procedure TfraImmEdit.cboRouteHistClick(Sender: TObject);
begin
    setSiteFromRoute(self.cboRouteHist, self.cboLocHist);
    if self.cboLocHist.Enabled = false then lblSiteHist.Enabled := false
    else lblSiteHist.Enabled := true;
end;

procedure TfraImmEdit.checkForMultipleCodes(immunization: string);
var
codeList: TStringList;
begin
  codeList := TStringList.create;
  try
    getCodeList(immunization, codeList);
    if codeList.Count < 2 then
      begin
        self.pnlCodes.Visible := false;
        exit;
      end;
    self.pnlCodes.Visible := true;
    self.pnlCodes.Enabled := true;
    FastAssign(codeList, self.cboCPT.Items);
  finally
    FreeAndNil(codeList);
  end;
end;

procedure TfraImmEdit.clearValues;
var
c, i: integer;
aControl: TControl;
pnl: TWinControl;
aGrid: TGridPanel;

  procedure clearPromptValues(Acontrol: TControl);
  begin
      if Acontrol is TORComboBox then
        begin
          TORComboBox(AControl).ItemIndex := -1;
          TORComboBox(AControl).Text := '';
        end
      else if AControl is TLabel then with TLabel(AControl) do Caption := 'Not Specified'
      else if AControl is TEdit then with TEdit(AControl) do Text := ''
      else if AControl is TMemo then with TMemo(AControl) do Clear
      else if AControl is TORListBox then with TORListBox(AControl) do Clear
      else if AControl is TListBox then with TListBox(AControl) do Clear
      else if AControl is TORDateBox then with TORDateBox(AControl) do text := ''
      else if AControl is TRadioGroup then with TRadioGroup(AControl) do itemIndex := -1;
  end;

  function clearLabel(aControl: TControl): boolean;
  begin
    result := false;
    if aControl.Name = 'lblExpDateValue' then result := true
    else if aControl.Name = 'lblManufacturerValue' then result := true
    else if aControl.Name = 'lblMDCValue' then result := True;
  end;

begin
  if self.pgeDisplay.ActivePage = pgAdmin then aGrid := gridPanel
  else if self.pgeDisplay.ActivePage = pgHist then aGrid := gridPanelHist
  else if self.pgeDisplay.ActivePage = pgRefuse then aGrid := gridPanelRef
  else if self.pgeDisplay.ActivePage = pgContr then aGrid := gridPanelContra
  else exit;

  for c := 0 to aGrid.ControlCollection.Count - 1 do
  begin
    pnl := TWinControl(aGrid.Controls[c]);
    for i := 0 to pnl.ControlCount - 1 do
      begin
        aControl := pnl.Controls[i];
        if self.pgeDisplay.ActivePage = pgAdmin then
          begin
            if aControl is TLabel and not clearLabel(aControl) then continue;
            if AControl.Name = 'cboAdminBy' then continue;
            if AControl.Name = 'cboOrderBy' then continue;
            if AControl.Name = 'dateAdminDate' then continue;
            clearPromptValues(Acontrol);
          end
        else
          begin
            if aControl is TLabel then continue;
            clearPromptValues(aControl);
          end;
      end;
  end;
  if isBlank = true then exit;
  spbtnExpandCollapseClick(self);
  if self.btnOk.Enabled = false then exit;
  agrid := TGridPanel(self.Parent);
  aControl := agrid.ControlCollection.Controls[0, 2];
  TfraImm(aControl).clearFields;
end;

procedure TfraImmEdit.collapse;
begin
    if not fCollapsed then
      begin
        clearValues;
        spbtnExpandCollapseClick(self);
      end;
end;

function TfraImmEdit.contraValidate(var vimmResult: TVimmResult): boolean;
var
idx: integer;
begin
  result := true;
  vimmResult.id := Piece(immDataStr, U, 1);
  vimmResult.name := Piece(immDataStr, u, 2);
  vimmResult.documType := 'Contraindication';
  //Require Fields
  idx := cboContra.ItemIndex;
  if idx = -1 then result := false
  else
    begin
      vimmResult.contraIEN := Piece(cboContra.Items.Strings[idx], U, 1);
      vimmResult.contra := Piece(cboContra.Items.Strings[idx], U, 2);
    end;
  //Optional Fields
  if dateWarncontra.FMDateTime > 0 then vimmResult.warnDate := dateWarncontra.FMDateTime;
  if commentContra.text <> '' then vimmResult.comments := commentContra.Text;
end;

constructor TfraImmEdit.Create(aOwner: TComponent);
var
i: integer;
begin
  inherited;
  style := ssPercent;
  minValue := 55;
  setPage(pgBlank, 'blank', false, false);
  adminInitialSet := false;
  for i := 0 to pgeDisplay.PageCount - 1 do
    begin
      pgeDisplay.Pages[i].TabVisible := false;
    end;
  spBtnExpandCollapse.Visible := false;
end;

procedure TfraImmEdit.dateAdminHistChange(Sender: TObject);
var
date: TFmDateTime;
begin
  date := dateAdminHist.FMDate;
  if (date > 2000000) and (date > adminDate) then
    begin
      dateAdminHist.FMDate := date - 10000;
    end;
end;

destructor TfraImmEdit.Destroy;
begin
    inherited;
end;

//destructor TfraImmEdit.Destroy;
//begin
//  inherited;
//end;

procedure TfraImmEdit.expand;
begin
  spbtnExpandCollapseClick(self);
end;

function TfraImmEdit.historicalValidate(var vimmResult: TVimmResult): boolean;
var
idx: integer;
begin
  result := true;
  vimmResult.id := Piece(immDataStr, U, 1);
  vimmResult.name := Piece(immDataStr, u, 2);
  vimmResult.documType := 'Historical';
  //required fields
    if dateAdminHist.FMDate = 0 then
      begin
        result := false;
        exit;
      end;
    if dateAdminHist.FMDate > adminDate then
      begin
        result := false;
        exit;
      end;
    vimmResult.adminDate := dateAdminHist.FMDate;
    //infoSource
    idx := cboInfoSource.ItemIndex;
    if idx > -1 then
      begin
        vimmResult.infoSourceIEN := Piece(cboInfoSource.Items[idx], U, 1);
        vimmResult.infoSource := Piece(cboInfoSource.items[idx], u, 2);
      end
    else
      begin
        result := false;
        exit;
      end;
    //optional fields
    if edtLot.Text <> ''  then vimmResult.lot := edtLot.Text;
    if dateExpiration.Text <> '' then vimmResult.expirationDate := dateExpiration.Text;
    if cboManuf.ItemIndex > -1 then vimmResult.manufacturer := Piece(cboManuf.Items.Strings[cboManuf.ItemIndex], u, 2);
    idx := cboRouteHist.ItemIndex;
    if idx > -1 then
      begin
        vimmResult.routeIEN := Piece(cboRouteHist.Items[idx], U, 1);
        vimmResult.route := Piece(cboRouteHist.items[idx], u, 2);
      end;
    //site
    idx := cboLocHist.ItemIndex;
    if idx > -1 then
      begin
        vimmResult.siteIEN := Piece(cboLocHist.Items[idx], U, 1);
        vimmResult.site := Piece(cboLocHist.items[idx], u, 2);
      end;
    idx := cboSeriesHist.ItemIndex;
    if idx > -1 then
    begin
      vimmResult.seriesId := Piece(cboSeriesHist.Items[idx], U, 1);
      vimmResult.series := Piece(cboSeriesHist.Items[idx], U, 2);
    end;
    //dosage Needs Validation
    if edtDosageHist.Text <> '' then vimmResult.dosage := edtDosageHist.Text;
    //outside location
    idx := cboOutLoc.ItemIndex;
    if idx > -1 then
      begin
        vimmResult.outsideLocIEN := Piece(cboOutLoc.Items[idx], U, 1);
        vimmResult.outsideLoc := Piece(cboOutLoc.items[idx], u, 2);
      end;
    //Manufacturer
    if cboManuf.ItemIndex > -1 then vimmResult.manufacturer := Piece(cboManuf.Items[cboManuf.ItemIndex], U, 2);

    if commentsHist.Text <> '' then vimmResult.comments := commentsHist.Text;
    vimMResult.adminByIEN := self.adminIEN;
    vimmResult.adminBy := self.adminName;
end;

function TfraImmEdit.refusalValidate(var vimmResult: TVimmResult): boolean;
var
idx: integer;
begin
  result := true;
  vimmResult.id := Piece(immDataStr, U, 1);
  vimmResult.name := Piece(immDataStr, u, 2);
  vimmResult.documType := 'Refused';
  //Require Fields
  idx := cboRefuse.ItemIndex;
  if idx = -1 then result := false
  else
    begin
      vimmResult.refuseIEN := Piece(cboRefuse.Items.Strings[idx], U, 1);
      vimmResult.refuse := Piece(cboRefuse.Items.Strings[idx], U, 2);
    end;
  //Optional Fields
  if dateWarn.FMDateTime > 0 then vimmResult.warnDate := dateWarn.FMDateTime;
  if commentRef.text <> '' then vimmResult.comments := commentref.Text;
end;

procedure TfraImmEdit.setAdminValues(immData: String);
var
idx: integer;
begin
     checkForCompleteVimmRecord(immData, self.adminDate);
     setLotComboBox(immData);
     setVISComboBox(immData);
     setSeriesItems(immData, cboSeries);
     cboAdminBy.InitLongList(self.adminName);
     checkForMultipleCodes(immData);
     idx := cboAdminBy.items.IndexOf(self.adminName);
     if idx > -1 then cboAdminBy.ItemIndex := idx;
     cboOrderBy.InitLongList(self.orderName);
     idx := cboOrderBy.items.IndexOf(self.orderName);
     if idx > -1 then cboOrderBy.itemindex := idx;
end;

procedure TfraImmEdit.setDefaultInputValues(immData: string);
var
vimmData: TVimm;
begin
  vimmData := getVimmData(immData);
  setControlValue(self.cboRoute, vimmData.routeDefault);
  if self.cboRoute.ItemIndex > -1 then
    begin
      self.cboRoute.OnClick(self.cboRoute);
      setControlValue(self.cboSite, vimmData.siteDefault);
    end;
  setControlValue(self.comments, vimmData.commentDefault);
  setControlValue(self.edtDosage, vimmData.doseDefault);
end;

procedure TfraImmEdit.setComboBox(control: TControl; name, id: string);
var
i, idx: integer;
begin
    idx := (control as TORComboBox).Items.IndexOf(name);
    if idx > -1 then (control as TORComboBox).ItemIndex := idx
    else
      begin
        idx := -1;
        for i := 0 to (control as TORComboBox).Items.Count - 1 do
           begin
             if Piece((control as TORComboBox).Items.Strings[i], u ,1) = id then
              begin
                idx := i;
                break;
              end;
           end;
         if idx > -1 then (control as TORComboBox).ItemIndex := idx;
       end;
end;

procedure TfraImmEdit.setControlValue(control: TControl; value: string);
var
i,idx: integer;
begin
  if control is TORComboBox then
    begin
      idx := -1;
        for i := 0 to (control as TORComboBox).Items.Count - 1 do
           begin
             if Piece((control as TORComboBox).Items.Strings[i], u ,1) = value then
              begin
                idx := i;
                break;
              end;
           end;
        if idx > -1 then (Control as TORCombobox).ItemIndex := idx;
    end;
  if control is TEdit then (control as TEdit).Text := value;
end;

procedure TfraImmEdit.setContraValues(immData: string);
begin
   checkForCompleteVimmRecord(immData, self.adminDate);
   self.cboContra.Items.Clear;
   getContraList(immData, self.cboContra.Items);
end;

procedure TfraImmEdit.setDefaultValues(immunization: string);
var
documType, name, vid: string;
begin
  vid := Piece(immunization, U, 1);
  name := Piece(immunization, U, 2);
  documType := Piece(immunization, u, 3);

end;

procedure TfraImmEdit.setDetails(immunization: string);
var
documType, name, vid: string;
vimm: TVimmResult;
begin
  vid := Piece(immunization, U, 1);
  name := Piece(immunization, U, 2);
  documType := Piece(immunization, u, 3);
  vimm := getVimmResult(StrToInt(vid));
  memoDetails.Lines := vimm.getNoteText;
end;

procedure TfraImmEdit.setEditFields(immunization: string);
var
documType, name, vid, visTemp: string;
i, idx: integer;
vimm: TVimmResult;
vimmCS: TVimmCS;
begin
  vid := Piece(immunization, U, 1);
  name := Piece(immunization, U, 2);
  documType := Piece(immunization, u, 3);
  vimm := getVimmResult(StrToInt(vid));
    if (vimm.lot <> '') or (vimm.lotIEN <> '') then
    begin
      setComboBox(cboLot, vimm.lot, vimm.lotIEN);
      if cboLot.ItemIndex > -1 then cboLotClick(cboLot);
    end;
  if (vimm.route <> '') or (vimm.routeIEN <> '') then
    begin
      setComboBox(cboRoute, vimm.route, vimm.routeIEN);
      if cboRoute.ItemIndex > -1 then setSiteFromRoute(self.cboRoute, self.cboSite);
    end;
  if (vimm.seriesId <> '') or (vimm.series <> '') then setComboBox(cboSeries, vimm.series, vimm.seriesId);
  if (vimm.site <> '') or (vimm.siteIEN <> '') then setComboBox(cboSite, vimm.site, vimm.siteIEN);
  if vimm.dosage <> '' then
    begin
      self.edtDosage.Text := vimm.dosage;
    end;
  if (self.pnlCodes.Visible) then
    begin
       vimmCS := vimm.procedureCode;
       idx := self.cboCPT.Items.IndexOf(vimmcs.narrative + ' ('+ vimmCS.code + ')');
       if idx > -1 then self.cboCPT.ItemIndex := idx;
    end;
  if vimm.comments <> '' then self.comments.Text := vimm.comments;
  if (vimm.overrideReason <> '') and (self.pnlOverride.Visible)  then
    begin
      self.edtOverride.Text := vimm.overrideReason;
    end;
  if (vimm.visList <> nil) and (vimm.visList.Count > 0) then
    begin
      for i := 0 to vimm.visList.Count - 1 do
        begin
          visTemp := vimm.visList.Strings[i];
          for idx := 0 to cboVIS.Items.Count - 1 do
            begin
              if Piece(cboVis.Items.Strings[idx], U, 1) = visTemp then cboVis.Checked[idx] := true;

            end;
        end;
    end;
end;

procedure TfraImmEdit.setEncounterData(date: TFMDateTime; orderName, orderIEN, adminName, adminIEN, loc, visitStr: string);
begin
  self.adminDate := date;
  self.orderName := orderName;
  self.orderIEN := orderIEN;
  self.adminName := adminName;
  self.adminIEN := adminIEN;
  self.location := loc;
  self.visitStr := visitStr;
end;

procedure TfraImmEdit.setHistValues(immData: string);
var
tempList: TStringList;
DefLoc: TStrings;
begin
   dateAdminHist.FMDate := adminDate;
   dateAdminHist.Month := 0;
   dateAdminHist.Day := 0;
   if self.cboInfoSource.Items.Count > 0 then exit;
   tempList := TStringList.Create;
   try
     getInfoSource(tempList);
     tempList.Delete(0);
     FastAssign(tempList, cboInfoSource.Items);
     setSeriesItems(immData, cboSeriesHist);
     tempList.Clear;
     LoadHistLocationsVIMM(tempList);
     loadManufacturerList(cboManuf.items);
     FastAssign(tempList, self.cboOutLoc.Items);
     defLoc := GetDefLocationsVIMM;
     if DefLoc.Count > 0 then setLookupDefaults(self.cboOutLoc, defLoc, 2);
   finally
     tempList.Free;
   end;
end;

procedure TfraImmEdit.setLookupDefaults(cbo: TORComboBox; items: TStrings; Num: integer);
var
idx, j, k: integer;
locText: string;
locFound: boolean;
begin
  idx := 0;
  for j := 0 to items.Count - 1 do
    begin
      LocText := Piece(items[j], U, num);
      if LocText <> '' then
        begin
          if (LocText <> '0') and (IntToStr(StrToIntDef(LocText, 0)) = LocText) then
            begin
              LocFound := FALSE;
              for k := 0 to cbo.items.Count - 1 do
                begin
                  if Piece(cbo.Items[k], U, num) = LocText then
                    begin
                      LocText := cbo.Items[k];
                      LocFound := TRUE;
                      break;
                    end;
                end;
              if not LocFound then LocText := '';
            end
          else
            begin
              if StrToIntDef(Piece(LocText, U, 1), -1) = -1 then LocText := '0^' + LocText;
            end;
          if LocText <> '' then
            begin
              cbo.items.insert(idx, LocText);
              inc(idx);
            end;
        end;
    end;
  if idx > 0 then
    begin
      cbo.Items.insert(idx, '-1' + LLS_LINE);
      cbo.Items.insert(idx + 1, '-1' + LLS_SPACE);
    end;
end;

procedure TfraImmEdit.setLotComboBox(immData: String);
var
  returnList: TStringList;
begin
    returnList := TStringList.Create();
    try
    getVimmLotForImmunization(immData, returnList);
    cboLot.Items.Clear;
    FastAssign(returnList, cboLot.Items);
    finally
      FreeAndNil(returnList);
    end;
end;

procedure TfraImmEdit.setPage(page: TTabSheet; immunization: string; edit, needsOverride: boolean);
var
tmpImmunization: string;
vimmData: TVimmResult;
begin
  if immunization = '' then
    begin
      clearValues(true);
      self.pgeDisplay.ActivePage := pgBlank;
      exit;
    end
  else if immunization <> 'blank' then
    begin
      if self.fCollapsed then self.expand;
      self.pgeDisplay.ActivePage := page;
      if page = pgDetails then
        begin
          setDetails(immunization);
          exit;
        end;
      if edit then
        begin
           vimmData := getVimmResult(StrToInt(Piece(immunization, U, 1)));
           tmpImmunization := vimmData.id + U + vimmData.name + U + vimmData.documType;
        end
      else tmpImmunization := immunization;

      immDataStr := tmpImmunization;
      setValues(tmpImmunization);
      if page = pgAdmin then
          begin
            if needsOverride then pnlOverride.Visible := true
            else if pnlOverride.Visible = true then pnlOverride.Visible := false;
            if (Piece(self.visitStr, ';', 3) = 'D') or (Piece(self.visitStr, ';', 3) = 'H')  then
              begin
                dateAdminDate.Enabled := true;
                lblAdminDate.Enabled := true;
              end
              else if self.adminDate > 0 then
              begin
                dateAdminDate.FMDateTime := self.adminDate;
                dateAdminDate.Enabled := false;
                lblAdminDate.Enabled := false;
              end;
            setAdminValues(tmpImmunization);
            if not edit then setDefaultInputValues(tmpImmunization);

          end
      else if page = pgHist then setHistValues(tmpImmunization)
      else if page = pgRefuse then setRefusalValues(tmpImmunization)
      else if page = pgContr then setContraValues(tmpImmunization);
    end
  else if self.pgeDisplay.ActivePage <> pgBlank then
    begin
      clearValues(true);
      self.pgeDisplay.ActivePage := pgBlank;
    end;
  if edit then setEditFields(immunization);

end;

procedure TfraImmEdit.setRefusalValues(immData: string);
begin
   if self.cboRefuse.Items.Count = 0 then getRefuseList(self.adminDate, '920.5', self.cboRefuse.Items);

end;

procedure TfraImmEdit.setSeriesItems(immunization: string; AControl: TControl);
var
tmp, value: string;
i, max, num: integer;
begin
  (AControl as TORComboBox).Items.Clear;
  value := getMaxSeries(immunization);
  if value = 'A' then FastAssign(immSeriesList, (AControl as TORComboBox).Items)
  else
    begin
      max := StrToIntDef(value, 0);
      if max = 0 then
        begin
          FastAssign(immSeriesList, (AControl as TORComboBox).Items);
          exit;
        end;
      for i := 0 to immSeriesList.Count -1 do
        begin
          tmp := immSeriesList[i];
          num := StrToIntDef(Piece(tmp, U, 1), 0);
          if num <= max then (AControl as TORComboBox).Items.Add(tmp);
        end;
    end;
end;

//determine if the anatomic location combobox should be enable or if it should have
//a default list.
procedure TfraImmEdit.setSiteFromRoute(iControl, dControl: TControl);
var
routeData: TVimmRoute;
idx: integer;
items: TStrings;
begin
  items := TStringList.Create;
  try
    idx := (iControl as TORComboBox).ItemIndex;
    if idx = -1 then exit;
    routeData := TVimmRoute((iControl as TORComboBox).Items.Objects[idx]);
    (dControl as TORComboBox).Enabled := true;
    (dControl as TORComboBox).itemindex := -1;
    (dControl as TORComboBox).Items.Clear;
    if routeData.none then (dControl as TORComboBox).Enabled := false
    else
      begin
        getAllSites((dControl as TORComboBox).Items);
        if routeData.all then exit;
        getDefaultSite(routeData.siteList, items);
        setLookupDefaults(TORComboBox(dControl), items, 1);
      end;
  finally
    FreeAndNil(items);
  end;
end;

procedure TfraImmEdit.setValues(immData: String);
var
routeList: TStringList;
i: integer;
data: TVimmRoute;
begin
    routeList := TStringList.Create;
    try
      if self.cboRoute.Items.Count = 0 then
        begin
          getImmRoute(routeList, self.adminDate);
          for i := 0 to routeList.Count - 1 do
            begin
              data := TVimmRoute(routeList.Objects[i]);
              self.cboRoute.Items.AddObject(data.text, data);
              self.cboRouteHist.Items.AddObject(data.text, data);
            end;
        end;
    getImmSite(self.adminDate);
    if self.immSeriesList = nil then self.immSeriesList := TStringList.Create;
    LoadImmSeries(cboSeries.Items);
    FastAssign(cboSeries.Items, cboSeriesHist.Items);
    FastAssign(self.cboSeries.items, immSeriesList);
    finally
       routeList.Free;
    end;
end;

procedure TfraImmEdit.setVISComboBox(immData: string);
var
visList: TStringList;
i, idx: integer;
temp, lookup: string;
begin
  cboVIS.Items.Clear;
  visList := TStringList.create();
  try
  lookup := '';
  getVimmVISForImmunization(immData, visList, lookup);
  for i := 0 to visList.count - 1 do
    begin
      temp := visList.Strings[i];
      cboVis.items.add(temp);
    end;
  if lookup <> '' then
    begin
      idx := cboVis.Items.IndexOf(lookup);
      if idx > -1 then cboVis.checked[idx] := true;
    end;
  finally
    FreeAndNil(visList);
  end;

end;

function TfraImmEdit.valiateFromParent: boolean;
begin
   result := validate;
end;

function TfraImmEdit.validate: boolean;
var
idx: integer;
vimmResult: TVimmResult;
grid: TGridPanel;
aControl: TControl;
noteList: TStringList;
begin
  noteList := TStringList.create;
  try
  vimmResult := TVimmResult.Create;
  if pgeDisplay.ActivePage = pgAdmin then result := adminValidate(vimmResult)
  else if pgeDisplay.ActivePage = pgHist then result := historicalValidate(vimmResult)
  else if pgeDisplay.ActivePage = pgRefuse then result := refusalValidate(vimmResult)
  else if pgeDisplay.ActivePage = pgContr then result := contraValidate(vimmResult)
  else result := false;
  if not result then
    begin
      infoBox('One or more fields is incomplete.' + CRLF + CRLF + 'Record not added to the immunization list', 'Error', MB_OK);
      vimmResult.Destroy;
      exit;
    end ;
  makeNoteList(visitStr,self.adminDate,location,vimmResult, noteList);
  getNoteText(noteList, vimmResult);
  idx := setVimmResults(vimmResult);
  if self.btnOk.Enabled = false then exit;
  grid := TGridPanel(self.Parent);
  aControl := grid.ControlCollection.Controls[0, 1];
  TfraGrid(aControl).updateGrid(idx);
  finally

  end;

end;

end.
